Public Class CarIsDeadException
    Inherits System.Exception

    ' Cette exception personnalise conserve le nom de la voiture condamne.
    Private carName As String
    Public Sub New()
    End Sub

    Public Sub New(ByVal carName As String)
        Me.carName = carName
    End Sub

    ' Surcharge de la proprit Exception.Message.
    Public Overrides ReadOnly Property Message() As String
        Get
            Dim msg As String = MyBase.Message
            msg &= carName & " a rendu l'me..."
            Return msg
        End Get
    End Property
End Class


' Exception personnalise.
'Public Class CarIsDeadException
'    Inherits System.Exception

'    Constructeur pour cette exception.
'    Public Sub New()
'    End Sub

'    Public Sub New(ByVal message As String)
'        MyBase.New(message)
'    End Sub
'    Public Sub New(ByVal message As String, ByVal innerEx As Exception)
'        MyBase.New(message, innerEx)
'    End Sub
'End Class

Public Class Radio

    Public Sub TurnOn(ByVal state As Boolean)

        If state = True Then
            Console.WriteLine("Diffusion en cours...")
        Else
            Console.WriteLine("Autoradio au repos...")
        End If
    End Sub
End Class

Public Class Car

    ' Donnes d'tat internes.
    Private currSpeed As Integer
    Private maxSpeed As Integer
    Public petName As String  ' Pour un accs ais...

    ' La voiture est-elle en tat de marche ou hors-service ?
    Private dead As Boolean

    ' Une voiture possde un auto-radio.
    Private theMusicBox As Radio

    Public Sub New()

        maxSpeed = 100
        dead = False
        ' La classe externe cr la classe interne
        ' au dmarrage
        ' NOTE: Dans le cas contraire, theMusicBox serait
        ' initialis avec une rfrence nulle.
        theMusicBox = New Radio()
    End Sub

    Public Sub New(ByVal name As String, ByVal max As Integer, ByVal curr As Integer)

        currSpeed = curr
        maxSpeed = max
        petName = name
        dead = False
        theMusicBox = New Radio()
    End Sub

    Public Sub CrankTunes(ByVal state As Boolean)

        ' Demande le dmarrage de la radio (ou l'arrt).
        ' Dlegue la requte  l'objet interne.
        theMusicBox.TurnOn(state)
    End Sub

    Public Sub SpeedUp(ByVal delta As Integer)

        ' Mauvais paramtre?
        If (delta < 0) Then
            Throw New ArgumentOutOfRangeException("La vitesse doit tre suprieure  zro")
        End If

        ' Si la voiture est hors-service, on l'indique...
        If (dead) Then
            ' Lancer une exception 'Car is dead' 
            Throw New CarIsDeadException(petName & " a rendu l'me !")
        Else
            currSpeed += delta
            If (currSpeed >= maxSpeed) Then
                dead = True
            Else
                Console.WriteLine("CurrSpeed = {0}", currSpeed)
            End If
        End If
    End Sub
End Class